/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.event;

import filenet.vw.base.VWDebug;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.EventListenerList;

public class VWSelectionChangeEventNotifier
implements ItemSelectable {
    private EventListenerList m_selectionChangeListeners = null;
    private Object[] m_items = null;

    public void notifySelectionChange(int nStateChange, Object item) {
        try {
            if (item == null) {
                this.m_items = null;
            } else {
                this.m_items = new Object[1];
                this.m_items[0] = item;
            }
            this.fireSelectionChangeNotification(nStateChange);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifySelectionChange(int nStateChange, Object[] items) {
        try {
            this.m_items = items;
            this.fireSelectionChangeNotification(nStateChange);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_selectionChangeListeners = null;
        this.m_items = null;
    }

    public void addItemListener(ItemListener listener) {
        if (this.m_selectionChangeListeners == null) {
            this.m_selectionChangeListeners = new EventListenerList();
        }
        this.removeItemListener(listener);
        this.m_selectionChangeListeners.add(ItemListener.class, listener);
    }

    public void removeItemListener(ItemListener listener) {
        if (this.m_selectionChangeListeners != null) {
            this.m_selectionChangeListeners.remove(ItemListener.class, listener);
        }
    }

    public Object[] getSelectedObjects() {
        return this.m_items;
    }

    private void fireSelectionChangeNotification(int nStateChange) {
        try {
            if (this.m_selectionChangeListeners != null && this.m_selectionChangeListeners.getListenerCount() > 0) {
                Object selectedItem = null;
                if (this.m_items != null && this.m_items.length > 0) {
                    selectedItem = this.m_items[0];
                }
                ItemEvent event = new ItemEvent(this, 0, selectedItem, nStateChange);
                Object[] listeners = this.m_selectionChangeListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ItemListener.class) continue;
                    ((ItemListener)listeners[i + 1]).itemStateChanged(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

